	list p=16f84a
	include <p16f84a.inc>
	LIST
; P16F84A.INC Standard Header File,Version 2.00 Microchip Technology
;00134 LIST
;2007 3FF1 
	__config _CP_OFF&_WDT_OFF&_XT_OSC&_PWRTE_ON
;Assembled using MPASM V2.30
;PORTA defines
	#define XOUT 0
	#define YOUT 1
	#define E 2
	#define RW 3

;PORTB defines
	#define CAL 4
	#define RS 5

;====================================================================
; RAM EQUATES
;====================================================================
	cblock 0x0c
T1XHi
T1XLo
ArgL
ArgH
AccHi
AccLo
DivCnt
PRODW3
PRODW2
PRODW1
PRODW0
DIV0
DIV1
ANS0
ANS1
T2Hi
T2Lo
T1YStartLo
T1YStartHi
T1YEndLo
T1YEndHi
T1YHi
T1YLo
ZXcalHi
ZXcalLo
ZYcalHi
ZYcalLo
T2calHi
T2calLo
ZXActualHi
ZXActualLo
ZYActualHi
ZYActualLo
XAccel
YAccel
Temp0
Temp1
Temp2
Temp3
Timer0H
EADR
EDATA
	endc

Count1 equ ArgL
Count2 equ ArgH
Temp equ Temp0
CMD equ ANS0
LDATA equ CMD
Digit0 equ DIV0
Digit1 equ DIV1
KHi equ 0x02
KLo equ 0xd0
	org 0x0000
	goto Start ;Go to start of program

	org 0x0004
	incf Timer0H,F
	bcf INTCON,T0IF
	bcf INTCON,RBIE
	retfie

Start
	bcf STATUS,RP0
	clrf PORTA
	clrf PORTB
	bsf STATUS,RP0 ;Bank1
	movlw B00000011 ;Set up the I/O ports
	movwf TRISA
	movlw B00010000
	movwf TRISB
	movlw B00001111
	movwf OPTION_REG
	bcf STATUS,RP0 ;Bank0
	call OpenXLCD ;Initialize LCD
	call RestoreCal ;Restore calibration constants
	bsf INTCON,GIE

Main
	call CheckCal ;Check if need to calibrate
	call ReadAccel ;Read the acceleration
	call FindZActual ;Calibrate readings
	call CalculateAccel ;Calculate tilt (acceleration)
	call DisplayAccel ;Display results
	movlw 0xff ;Delay for a while
	call Delay_Ms_4MHz
	movlw 0xff
	call Delay_Ms_4MHz
	goto Main ;Do it again

;********************************************************************
;====================================================================
;=========== Acceleration Measurement/Calculation Routines ==========
;====================================================================
;********************************************************************
;ReadAccel
; This subroutine acquires and calculates T1X, T1Y, and T2.
; T1X is in registers T1XHi,T1XLo
; T1Y is in registers T1YHi,T1YLo
; T2 is in registers T2Hi,T2Lo
;********************************************************************
ReadAccel
EDGE1
	btfsc PORTA,XOUT ;Wait for low on XOUT
	goto EDGE1
EDGE2
	btfss PORTA,XOUT ;Wait for high on XOUT
	goto EDGE2
	clrf TMR0 ;Clear Timer
	clrf Timer0H
	bcf INTCON,T0IF ;Enable Timer0 overflow interrupt
	bsf INTCON,T0IE
EDGE3
	btfsc PORTA,XOUT ;Look for falling edge on XOUT
	goto EDGE3
	movf TMR0,W ;Save Timer0H:TMR0 as T1X
	movwf T1XLo
	movf Timer0H,W
	movwf T1XHi
EDGE4
	btfsc PORTA,YOUT ;Look a low level on YOUT
	goto EDGE4
EDGE5
	btfss PORTA,YOUT ;Look for rising edge on YOUT
	goto EDGE5
	movf TMR0,W ;Save Timer0H:TMR0 for start
	movwf T1YStartLo ;of T1Y
	movf Timer0H,W
	movwf T1YStartHi
EDGE6
	btfsc PORTA,YOUT ;Look for falling edge on YOUT
	goto EDGE6
	movf TMR0,W ;Save Timer0H:TMR0 as the end
	movwf T1YEndLo ;of T1Y
	movf Timer0H,W
	movwf T1YEndHi
	bcf INTCON,T0IE
	movf T1YEndHi,W ;Calculate T1Y
	movwf AccHi
	movf T1YEndLo,W
	movwf AccLo
	movf T1YStartHi,W
	movwf ArgH
	movf T1YStartLo,W
	movwf ArgL
	call Sub16x16
	movf AccHi,W
	movwf T1YHi
	movf AccLo,W
	movwf T1YLo
	movf T1YEndHi,W ;CALCULATE T2
	movwf AccHi ;2*(T2Hi,T2Lo) = (T1YEndHi:T1YEndLo)+
	movf T1YEndLo,W ;(T1YStartHi:T1YStartLo)-(T1XHi:T1XLo)
	movwf AccLo
	movf T1YStartHi,W
	movwf ArgH
	movf T1YStartLo,W
	movwf ArgL
	call Add16x16 ;ACCHI,ACCLO=(T1YEndHi:T1YEendLo)+
	movf T1XHi,W ; (T1YStartHi:T1YStartLo)
	movwf ArgH
	movf T1XLo,W
	movwf ArgL
	call Sub16x16 ;ACCHI,ACCLO = 2*T2
	bcf STATUS,C
	rrf AccHi,F
	rrf AccLo,F
	movf AccHi,W
	movwf T2Hi
	movf AccLo,W
	movwf T2Lo
	return

;********************************************************************
;FindZActual
; This subroutine finds the value of ZActual for the X and Y
; axis.
; Output is ZXActualHi & ZXActualLo for the X-axis and
; ZYActualHi & ZXActualLo for the Y-axis.
;********************************************************************
FindZActual
	movf ZXcalHi,W ;First the X-axis
	movwf AccHi
	movf ZXcalLo,W
	movwf AccLo
	movf T2Hi,W
	movwf ArgH
	movf T2Lo,W
	movwf ArgL ;PRODW3,PRODW2,PRODW1,PRODW0 =
	call Mul16x16 ;(ZXCAL_HI,ZXCAL_LO)*(T2HI,T2LO)
	movf T2calHi,W
	movwf DIV1
	movf T2calLo,W
	movwf DIV0
	call Div32x16 ;ANS1,ANS0 = (ZXcal * T2) / T2cal
	movf ANS1,W
	movwf ZXActualHi
	movf ANS0,W
	movwf ZXActualLo
	movf ZYcalHi,W ;Same thing for the Y-axis
	movwf AccHi
	movf ZYcalLo,W
	movwf AccLo
	movf T2Hi,W
	movwf ArgH
	movf T2Lo,W
	movwf ArgL ;PRODW3,PRODW2,PRODW1,PRODW0 =
	call Mul16x16 ;(ZYCAL_HI,ZYCAL_LO)*(T2HI,T2LO)
	movf T2calHi,W
	movwf DIV1
	movf T2calLo,W
	movwf DIV0
	call Div32x16 ;ANS1,ANS0 = (ZYcal * T2) / T2cal
	movf ANS1,W
	movwf ZYActualHi
	movf ANS0,W
	movwf ZYActualLo
	return

;********************************************************************
;CalculateAccel
; This subroutine performs the acceleration calculation for
; each axis. The formula is:
; ACCEL = [K * (T1-Zactual) / T2actual]
; Output is XAccel and YAccel
;********************************************************************
CalculateAccel
HiW ;Check if acceleration is positive
	subwf T1XHi,W ;or negative by comparing
	btfss STATUS,C ;T1X and ZXactual
	goto CA1 ;Jump if T1X < ZXactual
	btfss STATUS,Z ;Test if T1XHI=ZX_ACTUAL_HI
	goto CA2 ;Jump if T1X > ZXactual
	movf ZXActualLo,W
	subwf T1XLo,W
	btfss STATUS,C
	goto CA1 ;Jump if TX1 < ZXactual
CA2
	movf T1XHi,W ;T1X - ZXactual
	movwf AccHi
	movf T1XLo,W
	movwf AccLo
	movf ZXActualHi,W
	movwf ArgH
	movf ZXActualLo,W
	movwf ArgL
	call Sub16x16
	movlw KHi
	movwf ArgH
	movlw KLo
	movwf ArgL
	call Mul16x16 ;PRODW3,PRODW2,PRODW1,PRODW0 =
;K * (T1X - ZXactual)
	movf T2Hi,W
	movwf DIV1
	movf T2Lo,W
	movwf DIV0
	call Div32x16 ;ANS1:ANS0=
	movf ANS0,W ; [K*(T1X-ZXactual)]/T2actual
	movwf XAccel ;The result will be a signed 8-bit #
	goto DoYCalc
CA1
	movf ZXActualHi,W ;ZXactual - T1X
	movwf AccHi
	movf ZXActualLo,W
	movwf AccLo
	movf T1XHi,W
	movwf ArgH
	movf T1XLo,W
	movwf ArgL
	call Sub16x16
	movlw KHi
	movwf ArgH
	movlw KLo
	movwf ArgL
	call Mul16x16 ;PRODW3,PRODW2,PRODW1,PRODW0 =
;K * (ZXactual - T1X)
	movf T2Hi,W
	movwf DIV1
	movf T2Lo,W
	movwf DIV0
	call Div32x16 ;ANS1,ANS0 =
	comf ANS0,W ; [K*(ZXactual-T1X)]/T2actual
	addlw 0x01 ;The result will be a signed 8-bit #
	movwf XAccel
DoYCalc
	movf ZYActualHi,W ;Check if acceleration is positive
	subwf T1YHi,W ;or negative by comparing
	btfss STATUS,C ;T1Y and ZYactual
	goto CA3 ;Jump if T1Y < ZYactual
	btfss STATUS,Z ;Test if T1YHI=ZY_ACTUAL_HI
	goto CA4 ;Jump if T1Y > ZYactual
	movf ZYActualLo,W
	subwf T1YLo,W
	btfss STATUS,C
	goto CA3 ;Jump if TY1 < ZYactual
CA4
	movf T1YHi,W ;T1Y - ZYactual
	movwf AccHi
	movf T1YLo,W
	movwf AccLo
	movf ZYActualHi,W
	movwf ArgH
	movf ZYActualLo,W
	movwf ArgL
	call Sub16x16
	movlw KHi
	movwf ArgH
	movlw KLo
	movwf ArgL
	call Mul16x16 ;PRODW3,PRODW2,PRODW1,PRODW0 =
;K * (T1Y - ZYactual)
	movf T2Hi,W
	movwf DIV1
	movf T2Lo,W
	movwf DIV0
	call Div32x16 ;ANS1,ANS0 =
	movf ANS0,W ; [K*(T1Y-ZYactual)]/T2actual
	movwf YAccel ;The result will be a signed 8-bit #
	return
CA3
	movf ZYActualHi,W ;ZYactual - T1Y
	movwf AccHi
	movf ZYActualLo,W
	movwf AccLo
	movf T1YHi,W
	movwf ArgH
	movf T1YLo,W
	movwf ArgL
	call Sub16x16
	movlw KHi
	movwf ArgH
	movlw KLo
	movwf ArgL
	call Mul16x16 ;PRODW3,PRODW2,PRODW1,PRODW0 =
;K * (ZYactual - T1Y)
	movf T2Hi,W
	movwf DIV1
	movf T2Lo,W
	movwf DIV0
	call Div32x16 ;ANS1,ANS0 =
	comf ANS0,W ;[K*(ZYactual-T1Y)]/T2actual
	addlw 0x01 ;The result will be a signed 8-bit #
	movwf YAccel
	return

;********************************************************************
;CheckCal
; This subroutine reads the CAL pushbutton switch (RB4) and if
; it is low, performs a simple calibration routine.
;********************************************************************
CheckCal
	btfsc PORTB,CAL ;Is RB4 low?
	return ;If not then exit routine
	call DisplayCal
	call ReadAccel ;If yes then perform a read cycle
	movf T2Hi,W ;Save the measured values in the
	movwf T2calHi ;calibration registers
	movf T2Lo,W
	movwf T2calLo
	movf T1XHi,W	
	movwf ZXcalHi
	movf T1XLo,W
	movwf ZXcalLo
	movf T1YHi,W
	movwf ZYcalHi
	movf T1YLo,W
	movwf ZYcalLo
	call WriteCal ;Write the calibration data to EEPROM
	call DisplayDone ;Write message to LCD display
CCLoop
	btfss PORTB,CAL ;Wait for pushbutton switch to be
	goto CCLoop ;released
	return
;********************************************************************

;====================================================================
;=================== Mathematical Operations ========================
;====================================================================
;********************************************************************
;Add16x16
; This subroutine performs a 16-bit by 16-bit addition.
; Note that this routine does not check for possible overflow
; results i.e., 17-bit sum.
; Inputs are AccHi:AccLo and ArgH:ArgL
; Result is in AccHi:AccLo
; (AccHi:AccLo) = (AccHi:AccLo)+(ArgH:ArgL)
;********************************************************************
Add16x16
	movf ArgL,W ;Add low bytes together
	addwf AccLo,F
	btfsc STATUS,C ;Check for carry out of addtion
	incf AccHi,F ;If yes, increment AccHi
	movf ArgH,W ;Add high bytes together
	addwf AccHi,F
	return

;********************************************************************
;Sub16x16
; This subroutine performs a 16-bit by 16-bit subtraction.
; Inputs are AccHi:AccLo and ArgH:ArgL
; Result is in AccHi:AccLo
; (AccHi:AccLo) = (AccHi:AccLo)-(ArgH:ArgL)
;********************************************************************
Sub16x16
	comf ArgL,F ;2s complement ArgH:ArgL
	incf ArgL,F
	btfsc STATUS,2
	decf ArgH,F
	comf ArgH,F
	movf ArgL,W ;Now perform a 16-bit addition
	addwf AccLo,F
	btfsc STATUS,W
	incf AccHi,F
	movf ArgH,W
	addwf AccHi,F
	return

;********************************************************************
;Mul16x16
; This subroutine performs a 16-bit by 16-bit multiplication.
; It produces a 32-bit number. Multiplication by 0 is checked
; and performed correctly, ie, A * 0 = 0.
; Inputs are (AccHi:AccLo) and (ArgH:ArgL)
; Output is (PRODW3:PRODW2:PRODW1:PRODW0)
; (PRODW3:PRODW2:PRODW1:PRODW0) = (AccHi:AccLo) * (Argh:ArgL)
;********************************************************************
Mul16x16
	clrf Temp0 ;Clear the temporary variables used
	clrf Temp1 ;in this routine	
	clrf Temp2
	clrf Temp3
	clrf PRODW0
	clrf PRODW1
	clrf PRODW2
	clrf PRODW3
	movf AccLo,W
	movwf Temp0 ;Move contents of AccHi:AccLo
	movf AccHi,W ;into Temp1:Temp0
	movwf Temp1
	movf AccHi,F ;Test if AccHi:AccLo = 0000
	btfss STATUS,Z
	goto CheckNext ;AccHi:AccLo not zero
	movf AccLo,F
	btfsc STATUS,Z
	goto Equal0 ;AccHi:AccLo = 0000
CheckNext
	movf ArgH,F ;Test if ArgH:ArgL = 0000
	btfss STATUS,Z
	goto DoMultiply ;ArgH:ArgL not zero
	movf ArgL,F
	btfsc STATUS,Z
	goto Equal0 ;ArgH:ArgL = 0000
DoMultiply
	movf ArgH,F ;Test if ArgH:ArgL has been reduced
	btfss STATUS,Z ;to 0
	goto TestLSB ;ArgH:ArgL has not been reduced to 0
	movf ArgL,F
	btfsc STATUS,Z
	return ;ArgH:ArgL has been reduced to zero
;so multiplication isdone
TestLSB
	bcf STATUS,C ;Shift ArgH:ArgL right
	rrf ArgH,F
	rrf ArgL,F
	btfss STATUS,C ;Is LSb of ArgH:ArgL = 1
	goto DoShift ;Jump if LSb = 0
	movf Temp0,W ;If LSb = 1 then
	addwf PRODW0,F ;PRODW3:PRODW2:PRODW1:PRODW0 =
	btfss STATUS,C ;PRODW3:PRODW2:PRODW1:PRODW0 +
	goto ADD2 ;Temp3:Temp2:Temp1:Temp0
	movlw 0x01 ;Add carry bit if necessary
	addwf PRODW1,F
	btfss STATUS,C
	goto ADD2
	movlw 0x01 ;Add carry bit if PRODW1 overflows
	addwf PRODW2,F ;as a result of the addition of the
	btfss STATUS,C ;previous carry
	goto ADD2
	incf PRODW3,F
ADD2
	movf Temp1,W
	addwf PRODW1,F
	btfss STATUS,C
	goto ADD3
	movlw 0x01
	addwf PRODW2,F
	btfss STATUS,C
	goto ADD3
	incf PRODW3,F
ADD3
	movf Temp2,W
	addwf PRODW2,F
	btfss STATUS,C
	goto ADD4
	incf PRODW3,F
ADD4
	movf Temp3,W
	addwf PRODW3,F
DoShift
	bcf STATUS,C ;Shift temp registers left
	rlf Temp0,F
	rlf Temp1,F
	rlf Temp2,F
	rlf Temp3,F
	goto DoMultiply
Equal0
	clrf PRODW0 ;Since one arguement equals zero
	clrf PRODW1 ;PRODW3,PRODW2,PRODW1,PRODW0 = 0
	clrf PRODW2
	clrf PRODW3
	return

;********************************************************************
;Div32x16
; This subroutine performs a 32-bit x 16-bit division.
; Division is performed by binary long division.
; Inputs are (PRODW3:PRODW2:PRODW1:PRODW0) and (DIV1:DIV0).
; Output is (ANS1:ANS0)
; (ANS1:ANS0) = (PRODW3:PRODW2:PRODW1:PRODW0) / (DIV1:DIV0)
;********************************************************************
Div32x16
	clrf ANS1 ;Clear the result registers
	clrf ANS0
	movlw 0x11 ;DivCnt = 17d
	movwf DivCnt
DA1
	movf DIV1,W
	subwf PRODW3,W ;Is DIV1 > PRODW3
	btfss STATUS,C
	goto NoSub ;Jump if DIV1 > PRODW3
	btfss STATUS,2 ;Is DIV1 = PRODW3
	goto DoSubs ;Jump if DIV1 < PRODW3
	movf DIV0,W ;Is DIV0 > PRODW2
	subwf PRODW2,W
	btfsc STATUS,C
	goto DoSubs ;Jump if DIV0 < PRODW2
NoSub
	bcf STATUS,C ;Clear the carry bit
	rlf ANS0,F ;Add 0 to LSb of ANS1,ANS0
	rlf ANS1,F
	bcf STATUS,C ;Clear the carry bit
	rlf PRODW0,F ;Shift PRODW3,2,1,0 left
	rlf PRODW1,F
	rlf PRODW2,F
	rlf PRODW3,F
	goto ChkCnt
DoSubs
	movf PRODW3,W
	movwf AccHi
	movf PRODW2,W
	movwf AccLo
	movf DIV1,W
	movwf ArgH
	movf DIV0,W
	movwf ArgL
	call Sub16x16 ;(PRODW3:2) = (PRODW3:2)-(DIV1:0)
	movf AccHi,W
	movwf PRODW3
	movf AccLo,W
	movwf PRODW2
	bsf STATUS,C
	rlf ANS0,F
	rlf ANS1,F ;Add 1 to LSb of ANS1:ANS0
	bcf STATUS,C
	rlf PRODW0,F ;Shift PRODW3,2,1,0, left
	rlf PRODW1,F
	rlf PRODW2,F
	rlf PRODW3,F
ChkCnt
	decfsz DivCnt,F ;Check for 17 operations
	goto DA1 ;If not then loop
	return
;********************************************************************

;====================================================================
;====================== Display Routines ============================
;====================================================================
;********************************************************************
;DisplayAccel
; This subroutine takes the values int XAccel and YAccel and
; displays the ASCII equivalent on the LCD display.
;********************************************************************
DisplayAccel
	call BusyXLCD ;Wait for LCD to not be busy
	movlw 0x01 ;Reset cursor to home position
	call WriteCmdXLCD ;of line 1

	btfss XAccel,7 ;Check if XAccel is negative
	goto XSpace
	call BusyXLCD ;Is negative
	movlw - ;Print a - to the display
	call WriteDataXLCD
	comf XAccel,W ;2s complement XAccel
	addlw 0x01
	movwf XAccel
	goto DispX
XSpace ;Not negative
	call BusyXLCD
	movlw   ;Print a space to the display
	call WriteDataXLCD
DispX
	movf XAccel,W ;Convert XAccel to 2-digit ASCII
	call Bin2Ascii
	call BusyXLCD
	movf Digit1,W ;Write the upper digit to the LCD
	call WriteDataXLCD
	call BusyXLCD
	movf Digit0,W ;Write the lower digit to the LCD
	call WriteDataXLCD
	call BusyXLCD
	movlw 0xdf ;Write a degrees symbol to the LCD
	call WriteDataXLCD
	call BusyXLCD
	movlw   ;Write " Pit" to the LCD
	call WriteDataXLCD ;for the word pitch which refers
	call BusyXLCD ;to the X-axis
	movlw P
	call WriteDataXLCD
	call BusyXLCD
	movlw i
	call WriteDataXLCD
	call BusyXLCD
	movlw t
	call WriteDataXLCD
	call BusyXLCD
	movlw 0xa8 ;Change the cursor position to home
	call WriteCmdXLCD ;of line 2

	btfss YAccel,7 ;Check if YAccel is negative
	goto YSpace
	call BusyXLCD ;Is negative
	movlw - ;Print a - to the display
	call WriteDataXLCD
	comf YAccel,W ;2s complement YAccel
	addlw 0x01
	movwf YAccel
	goto DispY
YSpace ;Not negative
	call BusyXLCD
	movlw   ;Print a space to the display
	call WriteDataXLCD
DispY
	movf YAccel,W ;Convert YAccel to 2-digit ASCII
	call Bin2Ascii
	call BusyXLCD
	movf Digit1,W ;Write the upper digit to the LCD
	call WriteDataXLCD
	call BusyXLCD
	movf Digit0,W ;Write the lower digit t the LCD
	call WriteDataXLCD
	call BusyXLCD
	movlw 0xdf ;Write a degrees symbol to the LCD
	call WriteDataXLCD
	call BusyXLCD
	movlw   ;Write " Rol" to the LCD
	call WriteDataXLCD ;for the word roll which refers
	call BusyXLCD ;to the Y-axis
	movlw R
	call WriteDataXLCD
	call BusyXLCD
	movlw o
	call WriteDataXLCD
	call BusyXLCD
	movlw l
	call WriteDataXLCD
	return

;********************************************************************
;OpenXLCD
; This subroutine initializes the LCD display. It is
; cleared and blank upon exit of this routine
;********************************************************************
OpenXLCD
	movlw 0x1e ;Delay for POR
	call Delay_Ms_4MHz

	movlw 0xf0 ;Write upper byte of configuration
	bsf STATUS,RP0 ;value to the LCD three times
	andwf TRISB,F ;After this the LCD can be read
	bcf STATUS,RP0
	andwf PORTB,F
	movlw 0x03
	iorwf PORTB,F ;Output data to the port, 8-bit mode
	bsf PORTA,E ;Clock the data in
	nop
	bcf PORTA,E

	movlw 0x0a ;Wait for ~5ms
	call Delay_Ms_4MHz

	movlw 0xf0
	andwf PORTB,F
	movlw 0x03
	iorwf PORTB,F ;Output data to the port, 8-bit mode
	bsf PORTA,E ;Clock the data in
	nop
	bcf PORTA,E

	movlw 0x0a ;Wait for ~5ms
	call Delay_Ms_4MHz

	movlw 0xf0
	andwf PORTB,F
	movlw 0x03
	iorwf PORTB,F ;Output data to the port, 8-bit mode
	bsf PORTA,E ;Clock the data in
	nop
	bcf PORTA,E
	
	movlw 0xf0
	andwf PORTB,F
	bsf PORTB,1 ;Output data to the port, 4-bit mode
	bsf PORTA,E
	nop
	bcf PORTA,E

	movlw 0x0f
	bsf STATUS,RP0
	iorwf TRISB,F
	bcf STATUS,RP0

	call BusyXLCD ;Function Set: 4-bit mode, 2 lines,
	movlw 0x2f ;5x8 dots
	call WriteCmdXLCD

	call BusyXLCD ;Display Cntrl: display, cursor off
	movlw 0x08
	call WriteCmdXLCD

	call BusyXLCD ;Display Cntrl: display & cursor on,
	movlw 0x0f ;blinking on
	call WriteCmdXLCD

	call BusyXLCD ;Clear Display
	movlw 0x01
	call WriteCmdXLCD

	call BusyXLCD ;Shift Cntrl: cursor moves to left
	movlw 0x13
	call WriteCmdXLCD

	call BusyXLCD ;Set DDRAM address to 0
	movlw 0x80
	call WriteCmdXLCD
	return

;********************************************************************
;WriteCmdXLCD
; This subroutine writes a command to the LCD display using
; a 4-bit interface.
;********************************************************************
WriteCmdXLCD
	bcf STATUS,RP0
	movwf CMD ;Save command in WREG to CMD
	movlw 0xf0 ;Setup up data port for write
	bsf STATUS,RP0
	andwf TRISB,F
	bcf STATUS,RP0
	andwf PORTB,F
	movf CMD,W ;Write upper 4-bits to data port
	movwf Temp
	swapf Temp,F
	movlw 0x0f
	andwf Temp,W
	andlw 0x0f
	iorwf PORTB,F
	bcf PORTA,RW ;Set the control bits for write
	bcf PORTB,RS ;and command
	nop
	bsf PORTA,E ;Clock the upper nibble in
	nop
	bcf PORTA,E
	movlw 0xf0
	andwf PORTB,F
	movlw 0x0f
	andwf CMD,W ;Output the lower 4-bits to data port	
	iorwf PORTB,F
	nop
	bsf PORTA,E ;Clock the lower nibble in
	nop
	bcf PORTA,E
	movlw 0x0f
	bsf STATUS,RP0
	iorwf TRISB,F
	bcf STATUS,RP0
	return

;********************************************************************
;BusyXLCD
; This subroutine monitors the busy bit from the LCD display
; It returns when the LCD is no longer busy.
;********************************************************************
BusyXLCD
	bcf STATUS,RP0
	bsf PORTA,RW ;Set up for a read
	bcf PORTB,RS ;Read the busy bit/address
	nop
	bsf PORTA,E ;Clock the data out
	nop
	btfss PORTB,3 ;Read the busy bit
	goto BNHI
	bcf PORTA,E ;Still busy
	nop
	bsf PORTA,E ;Clock out the lower nibble
	nop
	bcf PORTA,E
	bcf PORTA,RW
	goto BusyXLCD ;Try again
BNHI
	bcf PORTA,E ;LCD not busy
	nop
	bsf PORTA,E ;Clock out the lower nibble
	nop
	bcf PORTA,E
	bcf PORTA,RW
	return


;********************************************************************
;WriteDataXLCD
; This subroutine writes a byte of data to the LCD display
; using the 4-bit interface.
;********************************************************************
WriteDataXLCD
	bcf STATUS,RP0
	movwf LDATA ;Save the data in LDATA
	movlw 0xf0 ;Setup the data port
	bsf STATUS,RP0
	andwf TRISB,F
	bcf STATUS,RP0
	andwf PORTB,F
	movf LDATA,W ;Write the upper nibble of data
	movwf Temp ;to the data port
	swapf Temp,F
	movlw 0x0f
	andwf Temp,W
	andlw 0x0f
	iorwf PORTB,F
	bsf PORTB,RS ;Set control signals for write
	bcf PORTA,RW ;to data registers
	nop
	bsf PORTA,E ;Clock the upper nibble in
	nop
	bcf PORTA,E
	movlw 0xf0
	andwf PORTB,F
	movlw 0x0f
	andwf LDATA,W ;Write the lower nibble to data port
	iorwf PORTB,F
	nop
	bsf PORTA,E ;Clock the lower nibble in
	nop
	bcf PORTA,E
	movlw 0x0f
	bsf STATUS,RP0
	iorwf TRISB,F
	bcf STATUS,RP0
	return

;********************************************************************
;DisplayCal
; This subroutine displays a message to the LCD display
; indicating that a calibration cycle is in progress.
;********************************************************************
DisplayCal
	call BusyXLCD
	movlw 0x01
	call WriteCmdXLCD
	call BusyXLCD
	movlw C
	call WriteDataXLCD
	call BusyXLCD
	movlw a
	call WriteDataXLCD
	call BusyXLCD
	movlw l
	call WriteDataXLCD
	call BusyXLCD
	movlw i
	call WriteDataXLCD
	call BusyXLCD
	movlw b
	call WriteDataXLCD
	call BusyXLCD
	movlw r
	call WriteDataXLCD
	call BusyXLCD
	movlw a
	call WriteDataXLCD
	call BusyXLCD
	movlw t
	call WriteDataXLCD
	return

;********************************************************************
;DisplayDone
; This subroutine displays a message to the LCD display
; indicating that a calibration cycle has completed.
;********************************************************************
DisplayDone
	call BusyXLCD
	movlw 0xa8
	call WriteCmdXLCD
	call BusyXLCD
	movlw D
	call WriteDataXLCD
	call BusyXLCD
	movlw o
	call WriteDataXLCD
	call BusyXLCD
	movlw n
	call WriteDataXLCD
	call BusyXLCD
	movlw e
	call WriteDataXLCD
	return

;====================================================================
;======================= Misc. Routines =============================
;====================================================================
;********************************************************************
;Delay_Ms_4MHz
; Generic delay routine. Delay length in ms is loaded
; into WREG before calling.
;********************************************************************
Delay_Ms_4MHz
	bcf STATUS,RP0
	movwf Count1
DLMS2M1
	movlw 0x7c
	movwf Count2
DLMS2M2
	nop
	decfsz Count2,F
	goto DLMS2M2
	decfsz Count1,F
	goto DLMS2M1
	return

;********************************************************************
;Bin2Ascii
; This routine converts a binary number to a 2-digit ASCII
; number. The binary number is sent in WREG.
;********************************************************************
Bin2Ascii
	clrf Digit1 ;Clear the upper digit
	movwf Digit0 ;Save the binary number
B2A1
	movlw 0x0a ;Repeadedly subtract 10 from the
	subwf Digit0,W ;number until the result is less
	btfss STATUS,C ;then 10
	goto B2A2
	movwf Digit0
	incf Digit1,F
	goto B2A1
B2A2
	movlw 0x30 ;Add 0x30 to make the result
	addwf Digit0,F ;ASCII
	addwf Digit1,F
	retlw 0
;********************************************************************

;====================================================================
;==================== Data EEPROM Routines ==========================
;====================================================================
;********************************************************************
;WriteCal
; This subroutine takes 6 bytes starting with address
; ZXcalHi and writes them to the internal Data EEPROM.
; Calls to WriteEE perform the actual write sequence.
;********************************************************************
WriteCal
	movlw 0x06 ;Load byte counter with 6
	movwf Count1
	movlw ZXcalHi ;Load the starting address into FSR
	movwf FSR
	clrf EADR ;Start writing data to EE address 0
WCLoop
	movf INDF,W ;Load data
	movwf EDATA
	call WriteEE ;Call routine to write data
	incf EADR,F ;Increment EE address
	incf FSR,F ;Increment FSR
	decfsz Count1,F ;Decrement count
	goto WCLoop
	return


;********************************************************************
;RestoreCal
; This subroutine reads 6 bytes from the Data EE starting
; with address 0 and saves them starting with ZXcalHi.
; Calls to ReadEE perform the actual read sequence.
;********************************************************************
RestoreCal
	movlw 0x06 ;Load byte counter
	movwf Count1
	movlw ZXcalHi ;Load starting address into FSR
	movwf FSR
	clrf EADR ;Load starting EE address with 0
RCLoop
	call ReadEE ;Read data from EE
	movwf INDF ;Save in register
	incf EADR,F ;Increment EE address
	incf FSR,F ;Increment FSR
	decfsz Count1,F ;Decrement count
	goto RCLoop
	return

;********************************************************************
;WriteEE
; This is the subroutine to load the address and data into
; the special EE access registers and perform the EE write
; sequence.
;********************************************************************
WriteEE
	bcf STATUS,RP0
	movf EADR,W ;Load EE address
	movwf EEADR
	movf EDATA,W ;Load EE data
	movwf EEDATA
	bsf STATUS,RP0
	bcf EECON1,EEIF
	bsf EECON1,WREN ;EE write sequence
	movlw 0x55 ;must be performed
	movwf EECON2 ;in this order
	movlw 0xaa ;otherwise write
	movwf EECON2 ;does not take
	bsf EECON1,WR ;place correctly
eBusy
	btfss EECON1,EEIF ;Wait for write to complete
	goto eBusy
	bcf EECON1,WREN ;Disable writes
	bcf STATUS,RP0
	return

;********************************************************************
;ReadEE
; This is the subroutine to read from the data EE using the
; special EE access registers.
;********************************************************************
ReadEE
	bcf STATUS,RP0
	movf EADR,W ;Load EE address
	movwf EEADR
	bsf STATUS,RP0
	bsf EECON1,RD ;Perform the EE write sequence
	bcf STATUS,RP0
	movf EEDATA,W ;Move data into WREG
	return
	end